/*____________________________________________________________________________
        Copyright (C) 2000 Networks Associates Technology, Inc.
        All rights reserved.

        $Id: CLDAPX509KeyServer.h,v 1.4 2000/07/10 22:05:00 dallen Exp $
____________________________________________________________________________*/
#ifndef Included_CLDAPX509KeyServer_h	/* [ */
#define Included_CLDAPX509KeyServer_h


#include "pgpSockets.h"
#include "CKeyServer.h"
#include "pgpLDAP.h"
#include "pgpKeyServer.h"


class CLDAPX509KeyServer : public CKeyServer
{
public:
							CLDAPX509KeyServer(
								PGPContextRef					inContext,
								const char *					inHostName,
								PGPUInt32						inHostAddress,
								PGPUInt16						inHostPort,
								PGPKeyServerProtocol			inType,
								PGPKeyServerClass				inClass,
								PGPKeyServerAccessType			inAccessType );
	virtual					~CLDAPX509KeyServer();
	
	virtual void			Cancel();

	virtual void			Open( PGPtlsSessionRef inTLSSession );
	virtual void			Close();

	virtual void			Query(
								PGPFilterRef		inFilterRef,
								PGPKeyDBRef *		outFoundKeys);
	virtual void			GetAccessType( PGPKeyServerAccessType &outAccessType )
							{ 
								outAccessType = mAccessType;
							}
								
protected:
	PGPContextRef			mContext;
	PGPKeyServerAccessType	mAccessType;
	PGPldapContextRef		mLDAP;
	PGPExportFormat			mExportFormat;
	
};



#endif /* ] Included_CLDAPX509KeyServer_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
